// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of current spending limit. </summary>
    public readonly partial struct SpendingLimitStatus : IEquatable<SpendingLimitStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SpendingLimitStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SpendingLimitStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string NoneValue = "None";
        private const string ActiveValue = "Active";
        private const string ExpiredValue = "Expired";
        private const string LimitReachedValue = "LimitReached";
        private const string LimitRemovedValue = "LimitRemoved";

        /// <summary> Other. </summary>
        public static SpendingLimitStatus Other { get; } = new SpendingLimitStatus(OtherValue);
        /// <summary> None. </summary>
        public static SpendingLimitStatus None { get; } = new SpendingLimitStatus(NoneValue);
        /// <summary> Active. </summary>
        public static SpendingLimitStatus Active { get; } = new SpendingLimitStatus(ActiveValue);
        /// <summary> Expired. </summary>
        public static SpendingLimitStatus Expired { get; } = new SpendingLimitStatus(ExpiredValue);
        /// <summary> LimitReached. </summary>
        public static SpendingLimitStatus LimitReached { get; } = new SpendingLimitStatus(LimitReachedValue);
        /// <summary> LimitRemoved. </summary>
        public static SpendingLimitStatus LimitRemoved { get; } = new SpendingLimitStatus(LimitRemovedValue);
        /// <summary> Determines if two <see cref="SpendingLimitStatus"/> values are the same. </summary>
        public static bool operator ==(SpendingLimitStatus left, SpendingLimitStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SpendingLimitStatus"/> values are not the same. </summary>
        public static bool operator !=(SpendingLimitStatus left, SpendingLimitStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SpendingLimitStatus"/>. </summary>
        public static implicit operator SpendingLimitStatus(string value) => new SpendingLimitStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SpendingLimitStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SpendingLimitStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
