// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The ServiceDefinedResourceName. </summary>
    public readonly partial struct ServiceDefinedResourceName : IEquatable<ServiceDefinedResourceName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceDefinedResourceName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceDefinedResourceName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static ServiceDefinedResourceName Default { get; } = new ServiceDefinedResourceName(DefaultValue);
        /// <summary> Determines if two <see cref="ServiceDefinedResourceName"/> values are the same. </summary>
        public static bool operator ==(ServiceDefinedResourceName left, ServiceDefinedResourceName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceDefinedResourceName"/> values are not the same. </summary>
        public static bool operator !=(ServiceDefinedResourceName left, ServiceDefinedResourceName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceDefinedResourceName"/>. </summary>
        public static implicit operator ServiceDefinedResourceName(string value) => new ServiceDefinedResourceName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceDefinedResourceName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceDefinedResourceName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
