// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Savings plan update validate response. </summary>
    public partial class SavingsPlanValidateResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanValidateResult"/>. </summary>
        internal SavingsPlanValidateResult()
        {
            Benefits = new ChangeTrackingList<SavingsPlanValidResponseProperty>();
        }

        /// <summary> Initializes a new instance of <see cref="SavingsPlanValidateResult"/>. </summary>
        /// <param name="benefits"></param>
        /// <param name="nextLink"> Url to get the next page. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SavingsPlanValidateResult(IReadOnlyList<SavingsPlanValidResponseProperty> benefits, string nextLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Benefits = benefits;
            NextLink = nextLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the benefits. </summary>
        [WirePath("benefits")]
        public IReadOnlyList<SavingsPlanValidResponseProperty> Benefits { get; }
        /// <summary> Url to get the next page. </summary>
        [WirePath("nextLink")]
        public string NextLink { get; }
    }
}
