// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Savings plan utilization. </summary>
    public partial class SavingsPlanUtilization
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanUtilization"/>. </summary>
        internal SavingsPlanUtilization()
        {
            Aggregates = new ChangeTrackingList<SavingsPlanUtilizationAggregates>();
        }

        /// <summary> Initializes a new instance of <see cref="SavingsPlanUtilization"/>. </summary>
        /// <param name="trend"> The trend for a savings plan's utilization. </param>
        /// <param name="aggregates"> The array of aggregates of a savings plan's utilization. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SavingsPlanUtilization(string trend, IReadOnlyList<SavingsPlanUtilizationAggregates> aggregates, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Trend = trend;
            Aggregates = aggregates;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The trend for a savings plan's utilization. </summary>
        [WirePath("trend")]
        public string Trend { get; }
        /// <summary> The array of aggregates of a savings plan's utilization. </summary>
        [WirePath("aggregates")]
        public IReadOnlyList<SavingsPlanUtilizationAggregates> Aggregates { get; }
    }
}
