// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Savings plan patch request. </summary>
    public partial class SavingsPlanUpdateRequestProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanUpdateRequestProperties"/>. </summary>
        public SavingsPlanUpdateRequestProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SavingsPlanUpdateRequestProperties"/>. </summary>
        /// <param name="displayName"> Display name. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="renewProperties"> Properties specific to renew. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SavingsPlanUpdateRequestProperties(string displayName, BillingAppliedScopeType? appliedScopeType, BillingAppliedScopeProperties appliedScopeProperties, bool? isRenewed, BillingRenewProperties renewProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            AppliedScopeType = appliedScopeType;
            AppliedScopeProperties = appliedScopeProperties;
            IsRenewed = isRenewed;
            RenewProperties = renewProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
        /// <summary> Type of the Applied Scope. </summary>
        [WirePath("appliedScopeType")]
        public BillingAppliedScopeType? AppliedScopeType { get; set; }
        /// <summary> Properties specific to applied scope type. Not required if not applicable. </summary>
        [WirePath("appliedScopeProperties")]
        public BillingAppliedScopeProperties AppliedScopeProperties { get; set; }
        /// <summary> Setting this to true will automatically purchase a new benefit on the expiration date time. </summary>
        [WirePath("renew")]
        public bool? IsRenewed { get; set; }
        /// <summary> Properties specific to renew. </summary>
        internal BillingRenewProperties RenewProperties { get; set; }
        /// <summary> Purchase request. </summary>
        [WirePath("renewProperties.purchaseProperties")]
        public BillingPurchaseProperties RenewPurchaseProperties
        {
            get => RenewProperties is null ? default : RenewProperties.PurchaseProperties;
            set
            {
                if (RenewProperties is null)
                    RenewProperties = new BillingRenewProperties();
                RenewProperties.PurchaseProperties = value;
            }
        }
    }
}
