// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policy that controls whether users with Azure savings plan purchase are allowed. </summary>
    public readonly partial struct SavingsPlanPurchasesPolicy : IEquatable<SavingsPlanPurchasesPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanPurchasesPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SavingsPlanPurchasesPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllowedValue = "Allowed";
        private const string DisabledValue = "Disabled";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Other. </summary>
        public static SavingsPlanPurchasesPolicy Other { get; } = new SavingsPlanPurchasesPolicy(OtherValue);
        /// <summary> Allowed. </summary>
        public static SavingsPlanPurchasesPolicy Allowed { get; } = new SavingsPlanPurchasesPolicy(AllowedValue);
        /// <summary> Disabled. </summary>
        public static SavingsPlanPurchasesPolicy Disabled { get; } = new SavingsPlanPurchasesPolicy(DisabledValue);
        /// <summary> NotAllowed. </summary>
        public static SavingsPlanPurchasesPolicy NotAllowed { get; } = new SavingsPlanPurchasesPolicy(NotAllowedValue);
        /// <summary> Determines if two <see cref="SavingsPlanPurchasesPolicy"/> values are the same. </summary>
        public static bool operator ==(SavingsPlanPurchasesPolicy left, SavingsPlanPurchasesPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SavingsPlanPurchasesPolicy"/> values are not the same. </summary>
        public static bool operator !=(SavingsPlanPurchasesPolicy left, SavingsPlanPurchasesPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SavingsPlanPurchasesPolicy"/>. </summary>
        public static implicit operator SavingsPlanPurchasesPolicy(string value) => new SavingsPlanPurchasesPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SavingsPlanPurchasesPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SavingsPlanPurchasesPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
