// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The aggregate values of reservation utilization. </summary>
    public partial class ReservationUtilizationAggregates
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationUtilizationAggregates"/>. </summary>
        public ReservationUtilizationAggregates()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationUtilizationAggregates"/>. </summary>
        /// <param name="grain"> The grain of the aggregate. </param>
        /// <param name="grainUnit"> The grain unit of the aggregate. </param>
        /// <param name="value"> The aggregate value. </param>
        /// <param name="valueUnit"> The aggregate value unit. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationUtilizationAggregates(float? grain, string grainUnit, float? value, string valueUnit, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Grain = grain;
            GrainUnit = grainUnit;
            Value = value;
            ValueUnit = valueUnit;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The grain of the aggregate. </summary>
        [WirePath("grain")]
        public float? Grain { get; }
        /// <summary> The grain unit of the aggregate. </summary>
        [WirePath("grainUnit")]
        public string GrainUnit { get; }
        /// <summary> The aggregate value. </summary>
        [WirePath("value")]
        public float? Value { get; }
        /// <summary> The aggregate value unit. </summary>
        [WirePath("valueUnit")]
        public string ValueUnit { get; }
    }
}
