// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The renew properties for a reservation. </summary>
    public partial class ReservationRenewProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationRenewProperties"/>. </summary>
        public ReservationRenewProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationRenewProperties"/>. </summary>
        /// <param name="purchaseProperties"> The request for reservation purchase. </param>
        /// <param name="pricingCurrencyTotal"> Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included. This is locked price 30 days before expiry. </param>
        /// <param name="billingCurrencyTotal"> Currency and amount that customer will be charged in customer's local currency for renewal purchase. Tax is not included. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationRenewProperties(ReservationPurchaseRequest purchaseProperties, BillingPrice pricingCurrencyTotal, BillingPrice billingCurrencyTotal, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PurchaseProperties = purchaseProperties;
            PricingCurrencyTotal = pricingCurrencyTotal;
            BillingCurrencyTotal = billingCurrencyTotal;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The request for reservation purchase. </summary>
        [WirePath("purchaseProperties")]
        public ReservationPurchaseRequest PurchaseProperties { get; set; }
        /// <summary> Amount that Microsoft uses for record. Used during refund for calculating refund limit. Tax is not included. This is locked price 30 days before expiry. </summary>
        [WirePath("pricingCurrencyTotal")]
        public BillingPrice PricingCurrencyTotal { get; set; }
        /// <summary> Currency and amount that customer will be charged in customer's local currency for renewal purchase. Tax is not included. </summary>
        [WirePath("billingCurrencyTotal")]
        public BillingPrice BillingCurrencyTotal { get; set; }
    }
}
