// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Properties specific to applied scope type. Not required if not applicable. Required and need to provide tenantId and managementGroupId if AppliedScopeType is ManagementGroup. </summary>
    public partial class ReservationAppliedScopeProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationAppliedScopeProperties"/>. </summary>
        public ReservationAppliedScopeProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ReservationAppliedScopeProperties"/>. </summary>
        /// <param name="tenantId"> Tenant ID where the reservation should apply benefit. </param>
        /// <param name="managementGroupId"> Fully-qualified identifier of the management group where the benefit must be applied. </param>
        /// <param name="subscriptionId"> Fully-qualified identifier of the subscription. </param>
        /// <param name="resourceGroupId"> Fully-qualified identifier of the resource group. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationAppliedScopeProperties(Guid? tenantId, ResourceIdentifier managementGroupId, string subscriptionId, ResourceIdentifier resourceGroupId, string displayName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TenantId = tenantId;
            ManagementGroupId = managementGroupId;
            SubscriptionId = subscriptionId;
            ResourceGroupId = resourceGroupId;
            DisplayName = displayName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Tenant ID where the reservation should apply benefit. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> Fully-qualified identifier of the management group where the benefit must be applied. </summary>
        [WirePath("managementGroupId")]
        public ResourceIdentifier ManagementGroupId { get; set; }
        /// <summary> Fully-qualified identifier of the subscription. </summary>
        [WirePath("subscriptionId")]
        public string SubscriptionId { get; set; }
        /// <summary> Fully-qualified identifier of the resource group. </summary>
        [WirePath("resourceGroupId")]
        public ResourceIdentifier ResourceGroupId { get; set; }
        /// <summary> Display name. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
    }
}
