// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class RefundTransactionDetails : IUtf8JsonSerializable, IJsonModel<RefundTransactionDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RefundTransactionDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RefundTransactionDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundTransactionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RefundTransactionDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(AmountRequested))
            {
                writer.WritePropertyName("amountRequested"u8);
                writer.WriteObjectValue(AmountRequested, options);
            }
            if (options.Format != "W" && Optional.IsDefined(AmountRefunded))
            {
                writer.WritePropertyName("amountRefunded"u8);
                writer.WriteObjectValue(AmountRefunded, options);
            }
            if (Optional.IsDefined(RefundOperationId))
            {
                writer.WritePropertyName("refundOperationId"u8);
                writer.WriteStringValue(RefundOperationId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RefundTransactionDetails IJsonModel<RefundTransactionDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundTransactionDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RefundTransactionDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRefundTransactionDetails(document.RootElement, options);
        }

        internal static RefundTransactionDetails DeserializeRefundTransactionDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BillingAmount amountRequested = default;
            BillingAmount amountRefunded = default;
            string refundOperationId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("amountRequested"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    amountRequested = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("amountRefunded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    amountRefunded = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("refundOperationId"u8))
                {
                    refundOperationId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RefundTransactionDetails(amountRequested, amountRefunded, refundOperationId, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmountRequested), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amountRequested: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmountRequested))
                {
                    builder.Append("  amountRequested: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AmountRequested, options, 2, false, "  amountRequested: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmountRefunded), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amountRefunded: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmountRefunded))
                {
                    builder.Append("  amountRefunded: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AmountRefunded, options, 2, false, "  amountRefunded: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RefundOperationId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  refundOperationId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RefundOperationId))
                {
                    builder.Append("  refundOperationId: ");
                    if (RefundOperationId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RefundOperationId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RefundOperationId}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RefundTransactionDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundTransactionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RefundTransactionDetails)} does not support writing '{options.Format}' format.");
            }
        }

        RefundTransactionDetails IPersistableModel<RefundTransactionDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundTransactionDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRefundTransactionDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RefundTransactionDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RefundTransactionDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
