// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of refund request. </summary>
    public readonly partial struct RefundStatus : IEquatable<RefundStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RefundStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RefundStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string DeclinedValue = "Declined";
        private const string CancelledValue = "Cancelled";
        private const string CompletedValue = "Completed";
        private const string ExpiredValue = "Expired";

        /// <summary> Other. </summary>
        public static RefundStatus Other { get; } = new RefundStatus(OtherValue);
        /// <summary> Pending. </summary>
        public static RefundStatus Pending { get; } = new RefundStatus(PendingValue);
        /// <summary> Approved. </summary>
        public static RefundStatus Approved { get; } = new RefundStatus(ApprovedValue);
        /// <summary> Declined. </summary>
        public static RefundStatus Declined { get; } = new RefundStatus(DeclinedValue);
        /// <summary> Cancelled. </summary>
        public static RefundStatus Cancelled { get; } = new RefundStatus(CancelledValue);
        /// <summary> Completed. </summary>
        public static RefundStatus Completed { get; } = new RefundStatus(CompletedValue);
        /// <summary> Expired. </summary>
        public static RefundStatus Expired { get; } = new RefundStatus(ExpiredValue);
        /// <summary> Determines if two <see cref="RefundStatus"/> values are the same. </summary>
        public static bool operator ==(RefundStatus left, RefundStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RefundStatus"/> values are not the same. </summary>
        public static bool operator !=(RefundStatus left, RefundStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RefundStatus"/>. </summary>
        public static implicit operator RefundStatus(string value) => new RefundStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RefundStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RefundStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
