// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The reason for refund. </summary>
    public readonly partial struct RefundReasonCode : IEquatable<RefundReasonCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RefundReasonCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RefundReasonCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AccidentalConversionValue = "AccidentalConversion";
        private const string UnclearPricingValue = "UnclearPricing";
        private const string AccidentalPurchaseValue = "AccidentalPurchase";
        private const string ForgotToCancelValue = "ForgotToCancel";
        private const string UnclearDocumentationValue = "UnclearDocumentation";

        /// <summary> Other. </summary>
        public static RefundReasonCode Other { get; } = new RefundReasonCode(OtherValue);
        /// <summary> AccidentalConversion. </summary>
        public static RefundReasonCode AccidentalConversion { get; } = new RefundReasonCode(AccidentalConversionValue);
        /// <summary> UnclearPricing. </summary>
        public static RefundReasonCode UnclearPricing { get; } = new RefundReasonCode(UnclearPricingValue);
        /// <summary> AccidentalPurchase. </summary>
        public static RefundReasonCode AccidentalPurchase { get; } = new RefundReasonCode(AccidentalPurchaseValue);
        /// <summary> ForgotToCancel. </summary>
        public static RefundReasonCode ForgotToCancel { get; } = new RefundReasonCode(ForgotToCancelValue);
        /// <summary> UnclearDocumentation. </summary>
        public static RefundReasonCode UnclearDocumentation { get; } = new RefundReasonCode(UnclearDocumentationValue);
        /// <summary> Determines if two <see cref="RefundReasonCode"/> values are the same. </summary>
        public static bool operator ==(RefundReasonCode left, RefundReasonCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RefundReasonCode"/> values are not the same. </summary>
        public static bool operator !=(RefundReasonCode left, RefundReasonCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RefundReasonCode"/>. </summary>
        public static implicit operator RefundReasonCode(string value) => new RefundReasonCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RefundReasonCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RefundReasonCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
