// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The details of refund request. </summary>
    public partial class RefundDetailsSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RefundDetailsSummary"/>. </summary>
        public RefundDetailsSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RefundDetailsSummary"/>. </summary>
        /// <param name="requestedOn"> Date when the refund was requested. </param>
        /// <param name="approvedOn"> Date when the refund was approved. </param>
        /// <param name="completedOn"> Date when the refund was completed. </param>
        /// <param name="amountRequested"> The amount of refund requested. </param>
        /// <param name="amountRefunded"> The amount refunded. </param>
        /// <param name="rebillInvoiceId"> The invoice ID of the rebill invoice for a refund. </param>
        /// <param name="transactionCount"> The number of transactions refunded. </param>
        /// <param name="refundStatus"> The status of refund request. </param>
        /// <param name="refundOperationId"> The ID of refund operation. </param>
        /// <param name="refundReason"> The reason for refund. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RefundDetailsSummary(DateTimeOffset? requestedOn, DateTimeOffset? approvedOn, DateTimeOffset? completedOn, BillingAmount amountRequested, BillingAmount amountRefunded, ResourceIdentifier rebillInvoiceId, int? transactionCount, RefundStatus? refundStatus, string refundOperationId, RefundReasonCode? refundReason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RequestedOn = requestedOn;
            ApprovedOn = approvedOn;
            CompletedOn = completedOn;
            AmountRequested = amountRequested;
            AmountRefunded = amountRefunded;
            RebillInvoiceId = rebillInvoiceId;
            TransactionCount = transactionCount;
            RefundStatus = refundStatus;
            RefundOperationId = refundOperationId;
            RefundReason = refundReason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Date when the refund was requested. </summary>
        [WirePath("requestedOn")]
        public DateTimeOffset? RequestedOn { get; }
        /// <summary> Date when the refund was approved. </summary>
        [WirePath("approvedOn")]
        public DateTimeOffset? ApprovedOn { get; }
        /// <summary> Date when the refund was completed. </summary>
        [WirePath("completedOn")]
        public DateTimeOffset? CompletedOn { get; }
        /// <summary> The amount of refund requested. </summary>
        [WirePath("amountRequested")]
        public BillingAmount AmountRequested { get; }
        /// <summary> The amount refunded. </summary>
        [WirePath("amountRefunded")]
        public BillingAmount AmountRefunded { get; }
        /// <summary> The invoice ID of the rebill invoice for a refund. </summary>
        [WirePath("rebillInvoiceId")]
        public ResourceIdentifier RebillInvoiceId { get; }
        /// <summary> The number of transactions refunded. </summary>
        [WirePath("transactionCount")]
        public int? TransactionCount { get; }
        /// <summary> The status of refund request. </summary>
        [WirePath("refundStatus")]
        public RefundStatus? RefundStatus { get; }
        /// <summary> The ID of refund operation. </summary>
        [WirePath("refundOperationId")]
        public string RefundOperationId { get; }
        /// <summary> The reason for refund. </summary>
        [WirePath("refundReason")]
        public RefundReasonCode? RefundReason { get; }
    }
}
