// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class RefundDetailsSummary : IUtf8JsonSerializable, IJsonModel<RefundDetailsSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RefundDetailsSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RefundDetailsSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundDetailsSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RefundDetailsSummary)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(RequestedOn))
            {
                writer.WritePropertyName("requestedOn"u8);
                writer.WriteStringValue(RequestedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ApprovedOn))
            {
                writer.WritePropertyName("approvedOn"u8);
                writer.WriteStringValue(ApprovedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CompletedOn))
            {
                writer.WritePropertyName("completedOn"u8);
                writer.WriteStringValue(CompletedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(AmountRequested))
            {
                writer.WritePropertyName("amountRequested"u8);
                writer.WriteObjectValue(AmountRequested, options);
            }
            if (options.Format != "W" && Optional.IsDefined(AmountRefunded))
            {
                writer.WritePropertyName("amountRefunded"u8);
                writer.WriteObjectValue(AmountRefunded, options);
            }
            if (options.Format != "W" && Optional.IsDefined(RebillInvoiceId))
            {
                writer.WritePropertyName("rebillInvoiceId"u8);
                writer.WriteStringValue(RebillInvoiceId);
            }
            if (options.Format != "W" && Optional.IsDefined(TransactionCount))
            {
                writer.WritePropertyName("transactionCount"u8);
                writer.WriteNumberValue(TransactionCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RefundStatus))
            {
                writer.WritePropertyName("refundStatus"u8);
                writer.WriteStringValue(RefundStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RefundOperationId))
            {
                writer.WritePropertyName("refundOperationId"u8);
                writer.WriteStringValue(RefundOperationId);
            }
            if (options.Format != "W" && Optional.IsDefined(RefundReason))
            {
                writer.WritePropertyName("refundReason"u8);
                writer.WriteStringValue(RefundReason.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RefundDetailsSummary IJsonModel<RefundDetailsSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundDetailsSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RefundDetailsSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRefundDetailsSummary(document.RootElement, options);
        }

        internal static RefundDetailsSummary DeserializeRefundDetailsSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? requestedOn = default;
            DateTimeOffset? approvedOn = default;
            DateTimeOffset? completedOn = default;
            BillingAmount amountRequested = default;
            BillingAmount amountRefunded = default;
            ResourceIdentifier rebillInvoiceId = default;
            int? transactionCount = default;
            RefundStatus? refundStatus = default;
            string refundOperationId = default;
            RefundReasonCode? refundReason = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("requestedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    requestedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("approvedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    approvedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("completedOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    completedOn = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("amountRequested"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    amountRequested = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("amountRefunded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    amountRefunded = BillingAmount.DeserializeBillingAmount(property.Value, options);
                    continue;
                }
                if (property.NameEquals("rebillInvoiceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rebillInvoiceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("transactionCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    transactionCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("refundStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    refundStatus = new RefundStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("refundOperationId"u8))
                {
                    refundOperationId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("refundReason"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    refundReason = new RefundReasonCode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RefundDetailsSummary(
                requestedOn,
                approvedOn,
                completedOn,
                amountRequested,
                amountRefunded,
                rebillInvoiceId,
                transactionCount,
                refundStatus,
                refundOperationId,
                refundReason,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RequestedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  requestedOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RequestedOn))
                {
                    builder.Append("  requestedOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(RequestedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApprovedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  approvedOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApprovedOn))
                {
                    builder.Append("  approvedOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ApprovedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CompletedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  completedOn: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CompletedOn))
                {
                    builder.Append("  completedOn: ");
                    var formattedDateTimeString = TypeFormatters.ToString(CompletedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmountRequested), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amountRequested: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmountRequested))
                {
                    builder.Append("  amountRequested: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AmountRequested, options, 2, false, "  amountRequested: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AmountRefunded), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  amountRefunded: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AmountRefunded))
                {
                    builder.Append("  amountRefunded: ");
                    BicepSerializationHelpers.AppendChildObject(builder, AmountRefunded, options, 2, false, "  amountRefunded: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RebillInvoiceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rebillInvoiceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RebillInvoiceId))
                {
                    builder.Append("  rebillInvoiceId: ");
                    builder.AppendLine($"'{RebillInvoiceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TransactionCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  transactionCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TransactionCount))
                {
                    builder.Append("  transactionCount: ");
                    builder.AppendLine($"{TransactionCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RefundStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  refundStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RefundStatus))
                {
                    builder.Append("  refundStatus: ");
                    builder.AppendLine($"'{RefundStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RefundOperationId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  refundOperationId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RefundOperationId))
                {
                    builder.Append("  refundOperationId: ");
                    if (RefundOperationId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RefundOperationId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RefundOperationId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RefundReason), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  refundReason: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RefundReason))
                {
                    builder.Append("  refundReason: ");
                    builder.AppendLine($"'{RefundReason.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RefundDetailsSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundDetailsSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RefundDetailsSummary)} does not support writing '{options.Format}' format.");
            }
        }

        RefundDetailsSummary IPersistableModel<RefundDetailsSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RefundDetailsSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRefundDetailsSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RefundDetailsSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RefundDetailsSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
