// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The rebill details of an invoice. </summary>
    public partial class RebillDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RebillDetails"/>. </summary>
        internal RebillDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RebillDetails"/>. </summary>
        /// <param name="invoiceDocumentId"> The ID of invoice. </param>
        /// <param name="creditNoteDocumentId"> The ID of credit note. </param>
        /// <param name="rebillDetailsValue"> The rebill details of an invoice. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RebillDetails(ResourceIdentifier invoiceDocumentId, ResourceIdentifier creditNoteDocumentId, RebillDetails rebillDetailsValue, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            InvoiceDocumentId = invoiceDocumentId;
            CreditNoteDocumentId = creditNoteDocumentId;
            RebillDetailsValue = rebillDetailsValue;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The ID of invoice. </summary>
        [WirePath("invoiceDocumentId")]
        public ResourceIdentifier InvoiceDocumentId { get; }
        /// <summary> The ID of credit note. </summary>
        [WirePath("creditNoteDocumentId")]
        public ResourceIdentifier CreditNoteDocumentId { get; }
        /// <summary> The rebill details of an invoice. </summary>
        [WirePath("rebillDetails")]
        public RebillDetails RebillDetailsValue { get; }
    }
}
