// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class RebillDetails : IUtf8JsonSerializable, IJsonModel<RebillDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RebillDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RebillDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RebillDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RebillDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(InvoiceDocumentId))
            {
                writer.WritePropertyName("invoiceDocumentId"u8);
                writer.WriteStringValue(InvoiceDocumentId);
            }
            if (options.Format != "W" && Optional.IsDefined(CreditNoteDocumentId))
            {
                writer.WritePropertyName("creditNoteDocumentId"u8);
                writer.WriteStringValue(CreditNoteDocumentId);
            }
            if (options.Format != "W" && Optional.IsDefined(RebillDetailsValue))
            {
                writer.WritePropertyName("rebillDetails"u8);
                writer.WriteObjectValue(RebillDetailsValue, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        RebillDetails IJsonModel<RebillDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RebillDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RebillDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRebillDetails(document.RootElement, options);
        }

        internal static RebillDetails DeserializeRebillDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier invoiceDocumentId = default;
            ResourceIdentifier creditNoteDocumentId = default;
            RebillDetails rebillDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("invoiceDocumentId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    invoiceDocumentId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("creditNoteDocumentId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creditNoteDocumentId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("rebillDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rebillDetails = DeserializeRebillDetails(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RebillDetails(invoiceDocumentId, creditNoteDocumentId, rebillDetails, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InvoiceDocumentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  invoiceDocumentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InvoiceDocumentId))
                {
                    builder.Append("  invoiceDocumentId: ");
                    builder.AppendLine($"'{InvoiceDocumentId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreditNoteDocumentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  creditNoteDocumentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreditNoteDocumentId))
                {
                    builder.Append("  creditNoteDocumentId: ");
                    builder.AppendLine($"'{CreditNoteDocumentId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RebillDetailsValue), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  rebillDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RebillDetailsValue))
                {
                    builder.Append("  rebillDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, RebillDetailsValue, options, 2, false, "  rebillDetails: ");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RebillDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RebillDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RebillDetails)} does not support writing '{options.Format}' format.");
            }
        }

        RebillDetails IPersistableModel<RebillDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RebillDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRebillDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RebillDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RebillDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
