// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policy override for the subscription indicates whether the self-serve cancellation or seat reduction is allowed. </summary>
    public readonly partial struct PolicyOverrideCancellation : IEquatable<PolicyOverrideCancellation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PolicyOverrideCancellation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PolicyOverrideCancellation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotAllowedValue = "NotAllowed";
        private const string AllowedValue = "Allowed";

        /// <summary> NotAllowed. </summary>
        public static PolicyOverrideCancellation NotAllowed { get; } = new PolicyOverrideCancellation(NotAllowedValue);
        /// <summary> Allowed. </summary>
        public static PolicyOverrideCancellation Allowed { get; } = new PolicyOverrideCancellation(AllowedValue);
        /// <summary> Determines if two <see cref="PolicyOverrideCancellation"/> values are the same. </summary>
        public static bool operator ==(PolicyOverrideCancellation left, PolicyOverrideCancellation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PolicyOverrideCancellation"/> values are not the same. </summary>
        public static bool operator !=(PolicyOverrideCancellation left, PolicyOverrideCancellation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PolicyOverrideCancellation"/>. </summary>
        public static implicit operator PolicyOverrideCancellation(string value) => new PolicyOverrideCancellation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PolicyOverrideCancellation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PolicyOverrideCancellation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
