// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Indicates the eligibility status of the payment terms. </summary>
    public readonly partial struct PaymentTermsEligibilityStatus : IEquatable<PaymentTermsEligibilityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PaymentTermsEligibilityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PaymentTermsEligibilityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ValidValue = "Valid";
        private const string InvalidValue = "Invalid";

        /// <summary> Other. </summary>
        public static PaymentTermsEligibilityStatus Other { get; } = new PaymentTermsEligibilityStatus(OtherValue);
        /// <summary> Valid. </summary>
        public static PaymentTermsEligibilityStatus Valid { get; } = new PaymentTermsEligibilityStatus(ValidValue);
        /// <summary> Invalid. </summary>
        public static PaymentTermsEligibilityStatus Invalid { get; } = new PaymentTermsEligibilityStatus(InvalidValue);
        /// <summary> Determines if two <see cref="PaymentTermsEligibilityStatus"/> values are the same. </summary>
        public static bool operator ==(PaymentTermsEligibilityStatus left, PaymentTermsEligibilityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PaymentTermsEligibilityStatus"/> values are not the same. </summary>
        public static bool operator !=(PaymentTermsEligibilityStatus left, PaymentTermsEligibilityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PaymentTermsEligibilityStatus"/>. </summary>
        public static implicit operator PaymentTermsEligibilityStatus(string value) => new PaymentTermsEligibilityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PaymentTermsEligibilityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PaymentTermsEligibilityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
