// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class PaymentTermsEligibilityResult : IUtf8JsonSerializable, IJsonModel<PaymentTermsEligibilityResult>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PaymentTermsEligibilityResult>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PaymentTermsEligibilityResult>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PaymentTermsEligibilityResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PaymentTermsEligibilityResult)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(EligibilityStatus))
            {
                writer.WritePropertyName("eligibilityStatus"u8);
                writer.WriteStringValue(EligibilityStatus.Value.ToString());
            }
            if (Optional.IsCollectionDefined(EligibilityDetails))
            {
                writer.WritePropertyName("eligibilityDetails"u8);
                writer.WriteStartArray();
                foreach (var item in EligibilityDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PaymentTermsEligibilityResult IJsonModel<PaymentTermsEligibilityResult>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PaymentTermsEligibilityResult>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PaymentTermsEligibilityResult)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePaymentTermsEligibilityResult(document.RootElement, options);
        }

        internal static PaymentTermsEligibilityResult DeserializePaymentTermsEligibilityResult(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            PaymentTermsEligibilityStatus? eligibilityStatus = default;
            IReadOnlyList<PaymentTermsEligibilityDetail> eligibilityDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("eligibilityStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    eligibilityStatus = new PaymentTermsEligibilityStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("eligibilityDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<PaymentTermsEligibilityDetail> array = new List<PaymentTermsEligibilityDetail>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(PaymentTermsEligibilityDetail.DeserializePaymentTermsEligibilityDetail(item, options));
                    }
                    eligibilityDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PaymentTermsEligibilityResult(eligibilityStatus, eligibilityDetails ?? new ChangeTrackingList<PaymentTermsEligibilityDetail>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EligibilityStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  eligibilityStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EligibilityStatus))
                {
                    builder.Append("  eligibilityStatus: ");
                    builder.AppendLine($"'{EligibilityStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EligibilityDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  eligibilityDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(EligibilityDetails))
                {
                    if (EligibilityDetails.Any())
                    {
                        builder.Append("  eligibilityDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in EligibilityDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  eligibilityDetails: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PaymentTermsEligibilityResult>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PaymentTermsEligibilityResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PaymentTermsEligibilityResult)} does not support writing '{options.Format}' format.");
            }
        }

        PaymentTermsEligibilityResult IPersistableModel<PaymentTermsEligibilityResult>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PaymentTermsEligibilityResult>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePaymentTermsEligibilityResult(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PaymentTermsEligibilityResult)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PaymentTermsEligibilityResult>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
