// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Indicates the reason for the ineligibility of the payment terms. </summary>
    public readonly partial struct PaymentTermsEligibilityCode : IEquatable<PaymentTermsEligibilityCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PaymentTermsEligibilityCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PaymentTermsEligibilityCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string OverlappingPaymentTermsValue = "OverlappingPaymentTerms";
        private const string InvalidDateFormatValue = "InvalidDateFormat";
        private const string InvalidDateRangeValue = "InvalidDateRange";
        private const string InactiveBillingAccountValue = "InactiveBillingAccount";
        private const string InvalidBillingAccountTypeValue = "InvalidBillingAccountType";
        private const string NullOrEmptyPaymentTermsValue = "NullOrEmptyPaymentTerms";
        private const string BillingAccountNotFoundValue = "BillingAccountNotFound";
        private const string IneligibleBillingAccountStatusValue = "IneligibleBillingAccountStatus";
        private const string InvalidTermsValue = "InvalidTerms";

        /// <summary> Other. </summary>
        public static PaymentTermsEligibilityCode Other { get; } = new PaymentTermsEligibilityCode(OtherValue);
        /// <summary> OverlappingPaymentTerms. </summary>
        public static PaymentTermsEligibilityCode OverlappingPaymentTerms { get; } = new PaymentTermsEligibilityCode(OverlappingPaymentTermsValue);
        /// <summary> InvalidDateFormat. </summary>
        public static PaymentTermsEligibilityCode InvalidDateFormat { get; } = new PaymentTermsEligibilityCode(InvalidDateFormatValue);
        /// <summary> InvalidDateRange. </summary>
        public static PaymentTermsEligibilityCode InvalidDateRange { get; } = new PaymentTermsEligibilityCode(InvalidDateRangeValue);
        /// <summary> InactiveBillingAccount. </summary>
        public static PaymentTermsEligibilityCode InactiveBillingAccount { get; } = new PaymentTermsEligibilityCode(InactiveBillingAccountValue);
        /// <summary> InvalidBillingAccountType. </summary>
        public static PaymentTermsEligibilityCode InvalidBillingAccountType { get; } = new PaymentTermsEligibilityCode(InvalidBillingAccountTypeValue);
        /// <summary> NullOrEmptyPaymentTerms. </summary>
        public static PaymentTermsEligibilityCode NullOrEmptyPaymentTerms { get; } = new PaymentTermsEligibilityCode(NullOrEmptyPaymentTermsValue);
        /// <summary> BillingAccountNotFound. </summary>
        public static PaymentTermsEligibilityCode BillingAccountNotFound { get; } = new PaymentTermsEligibilityCode(BillingAccountNotFoundValue);
        /// <summary> IneligibleBillingAccountStatus. </summary>
        public static PaymentTermsEligibilityCode IneligibleBillingAccountStatus { get; } = new PaymentTermsEligibilityCode(IneligibleBillingAccountStatusValue);
        /// <summary> InvalidTerms. </summary>
        public static PaymentTermsEligibilityCode InvalidTerms { get; } = new PaymentTermsEligibilityCode(InvalidTermsValue);
        /// <summary> Determines if two <see cref="PaymentTermsEligibilityCode"/> values are the same. </summary>
        public static bool operator ==(PaymentTermsEligibilityCode left, PaymentTermsEligibilityCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PaymentTermsEligibilityCode"/> values are not the same. </summary>
        public static bool operator !=(PaymentTermsEligibilityCode left, PaymentTermsEligibilityCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PaymentTermsEligibilityCode"/>. </summary>
        public static implicit operator PaymentTermsEligibilityCode(string value) => new PaymentTermsEligibilityCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PaymentTermsEligibilityCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PaymentTermsEligibilityCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
