// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Status of the payment method. </summary>
    public readonly partial struct PaymentMethodStatus : IEquatable<PaymentMethodStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PaymentMethodStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PaymentMethodStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "active";
        private const string InactiveValue = "inactive";

        /// <summary> active. </summary>
        public static PaymentMethodStatus Active { get; } = new PaymentMethodStatus(ActiveValue);
        /// <summary> inactive. </summary>
        public static PaymentMethodStatus Inactive { get; } = new PaymentMethodStatus(InactiveValue);
        /// <summary> Determines if two <see cref="PaymentMethodStatus"/> values are the same. </summary>
        public static bool operator ==(PaymentMethodStatus left, PaymentMethodStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PaymentMethodStatus"/> values are not the same. </summary>
        public static bool operator !=(PaymentMethodStatus left, PaymentMethodStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PaymentMethodStatus"/>. </summary>
        public static implicit operator PaymentMethodStatus(string value) => new PaymentMethodStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PaymentMethodStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PaymentMethodStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
