// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of a transfer. </summary>
    public readonly partial struct PartnerTransferStatus : IEquatable<PartnerTransferStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PartnerTransferStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PartnerTransferStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ExpiredValue = "Expired";
        private const string PendingValue = "Pending";
        private const string InProgressValue = "InProgress";
        private const string CompletedValue = "Completed";
        private const string CompletedWithErrorsValue = "CompletedWithErrors";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string DeclinedValue = "Declined";

        /// <summary> Expired. </summary>
        public static PartnerTransferStatus Expired { get; } = new PartnerTransferStatus(ExpiredValue);
        /// <summary> Pending. </summary>
        public static PartnerTransferStatus Pending { get; } = new PartnerTransferStatus(PendingValue);
        /// <summary> InProgress. </summary>
        public static PartnerTransferStatus InProgress { get; } = new PartnerTransferStatus(InProgressValue);
        /// <summary> Completed. </summary>
        public static PartnerTransferStatus Completed { get; } = new PartnerTransferStatus(CompletedValue);
        /// <summary> CompletedWithErrors. </summary>
        public static PartnerTransferStatus CompletedWithErrors { get; } = new PartnerTransferStatus(CompletedWithErrorsValue);
        /// <summary> Failed. </summary>
        public static PartnerTransferStatus Failed { get; } = new PartnerTransferStatus(FailedValue);
        /// <summary> Canceled. </summary>
        public static PartnerTransferStatus Canceled { get; } = new PartnerTransferStatus(CanceledValue);
        /// <summary> Declined. </summary>
        public static PartnerTransferStatus Declined { get; } = new PartnerTransferStatus(DeclinedValue);
        /// <summary> Determines if two <see cref="PartnerTransferStatus"/> values are the same. </summary>
        public static bool operator ==(PartnerTransferStatus left, PartnerTransferStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PartnerTransferStatus"/> values are not the same. </summary>
        public static bool operator !=(PartnerTransferStatus left, PartnerTransferStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PartnerTransferStatus"/>. </summary>
        public static implicit operator PartnerTransferStatus(string value) => new PartnerTransferStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PartnerTransferStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PartnerTransferStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
