// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Billing cycle details of the product. </summary>
    internal partial class NextBillingCycleDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NextBillingCycleDetails"/>. </summary>
        internal NextBillingCycleDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="NextBillingCycleDetails"/>. </summary>
        /// <param name="nextBillingCycleBillingFrequency"> Billing frequency of the product under the subscription. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NextBillingCycleDetails(string nextBillingCycleBillingFrequency, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NextBillingCycleBillingFrequency = nextBillingCycleBillingFrequency;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Billing frequency of the product under the subscription. </summary>
        [WirePath("billingFrequency")]
        public string NextBillingCycleBillingFrequency { get; }
    }
}
