// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Error code for the product transfer validation. </summary>
    public readonly partial struct MoveValidationErrorCode : IEquatable<MoveValidationErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MoveValidationErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MoveValidationErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string BillingAccountInactiveValue = "BillingAccountInactive";
        private const string DestinationBillingProfileInactiveValue = "DestinationBillingProfileInactive";
        private const string DestinationBillingProfileNotFoundValue = "DestinationBillingProfileNotFound";
        private const string DestinationBillingProfilePastDueValue = "DestinationBillingProfilePastDue";
        private const string DestinationInvoiceSectionInactiveValue = "DestinationInvoiceSectionInactive";
        private const string DestinationInvoiceSectionNotFoundValue = "DestinationInvoiceSectionNotFound";
        private const string InsufficientPermissionOnDestinationValue = "InsufficientPermissionOnDestination";
        private const string InsufficientPermissionOnSourceValue = "InsufficientPermissionOnSource";
        private const string InvalidDestinationValue = "InvalidDestination";
        private const string InvalidSourceValue = "InvalidSource";
        private const string MarketplaceNotEnabledOnDestinationValue = "MarketplaceNotEnabledOnDestination";
        private const string ProductInactiveValue = "ProductInactive";
        private const string ProductNotFoundValue = "ProductNotFound";
        private const string ProductTypeNotSupportedValue = "ProductTypeNotSupported";
        private const string SourceBillingProfilePastDueValue = "SourceBillingProfilePastDue";
        private const string SourceInvoiceSectionInactiveValue = "SourceInvoiceSectionInactive";

        /// <summary> Other. </summary>
        public static MoveValidationErrorCode Other { get; } = new MoveValidationErrorCode(OtherValue);
        /// <summary> BillingAccountInactive. </summary>
        public static MoveValidationErrorCode BillingAccountInactive { get; } = new MoveValidationErrorCode(BillingAccountInactiveValue);
        /// <summary> DestinationBillingProfileInactive. </summary>
        public static MoveValidationErrorCode DestinationBillingProfileInactive { get; } = new MoveValidationErrorCode(DestinationBillingProfileInactiveValue);
        /// <summary> DestinationBillingProfileNotFound. </summary>
        public static MoveValidationErrorCode DestinationBillingProfileNotFound { get; } = new MoveValidationErrorCode(DestinationBillingProfileNotFoundValue);
        /// <summary> DestinationBillingProfilePastDue. </summary>
        public static MoveValidationErrorCode DestinationBillingProfilePastDue { get; } = new MoveValidationErrorCode(DestinationBillingProfilePastDueValue);
        /// <summary> DestinationInvoiceSectionInactive. </summary>
        public static MoveValidationErrorCode DestinationInvoiceSectionInactive { get; } = new MoveValidationErrorCode(DestinationInvoiceSectionInactiveValue);
        /// <summary> DestinationInvoiceSectionNotFound. </summary>
        public static MoveValidationErrorCode DestinationInvoiceSectionNotFound { get; } = new MoveValidationErrorCode(DestinationInvoiceSectionNotFoundValue);
        /// <summary> InsufficientPermissionOnDestination. </summary>
        public static MoveValidationErrorCode InsufficientPermissionOnDestination { get; } = new MoveValidationErrorCode(InsufficientPermissionOnDestinationValue);
        /// <summary> InsufficientPermissionOnSource. </summary>
        public static MoveValidationErrorCode InsufficientPermissionOnSource { get; } = new MoveValidationErrorCode(InsufficientPermissionOnSourceValue);
        /// <summary> InvalidDestination. </summary>
        public static MoveValidationErrorCode InvalidDestination { get; } = new MoveValidationErrorCode(InvalidDestinationValue);
        /// <summary> InvalidSource. </summary>
        public static MoveValidationErrorCode InvalidSource { get; } = new MoveValidationErrorCode(InvalidSourceValue);
        /// <summary> MarketplaceNotEnabledOnDestination. </summary>
        public static MoveValidationErrorCode MarketplaceNotEnabledOnDestination { get; } = new MoveValidationErrorCode(MarketplaceNotEnabledOnDestinationValue);
        /// <summary> ProductInactive. </summary>
        public static MoveValidationErrorCode ProductInactive { get; } = new MoveValidationErrorCode(ProductInactiveValue);
        /// <summary> ProductNotFound. </summary>
        public static MoveValidationErrorCode ProductNotFound { get; } = new MoveValidationErrorCode(ProductNotFoundValue);
        /// <summary> ProductTypeNotSupported. </summary>
        public static MoveValidationErrorCode ProductTypeNotSupported { get; } = new MoveValidationErrorCode(ProductTypeNotSupportedValue);
        /// <summary> SourceBillingProfilePastDue. </summary>
        public static MoveValidationErrorCode SourceBillingProfilePastDue { get; } = new MoveValidationErrorCode(SourceBillingProfilePastDueValue);
        /// <summary> SourceInvoiceSectionInactive. </summary>
        public static MoveValidationErrorCode SourceInvoiceSectionInactive { get; } = new MoveValidationErrorCode(SourceInvoiceSectionInactiveValue);
        /// <summary> Determines if two <see cref="MoveValidationErrorCode"/> values are the same. </summary>
        public static bool operator ==(MoveValidationErrorCode left, MoveValidationErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MoveValidationErrorCode"/> values are not the same. </summary>
        public static bool operator !=(MoveValidationErrorCode left, MoveValidationErrorCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MoveValidationErrorCode"/>. </summary>
        public static implicit operator MoveValidationErrorCode(string value) => new MoveValidationErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MoveValidationErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MoveValidationErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
