// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Error details of the transfer eligibility validation. </summary>
    public partial class MoveProductErrorDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MoveProductErrorDetails"/>. </summary>
        internal MoveProductErrorDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MoveProductErrorDetails"/>. </summary>
        /// <param name="code"> Error code for the product transfer validation. </param>
        /// <param name="message"> The error message. </param>
        /// <param name="details"> Error details of the transfer eligibility validation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MoveProductErrorDetails(MoveValidationErrorCode? code, string message, string details, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            Message = message;
            Details = details;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Error code for the product transfer validation. </summary>
        [WirePath("code")]
        public MoveValidationErrorCode? Code { get; }
        /// <summary> The error message. </summary>
        [WirePath("message")]
        public string Message { get; }
        /// <summary> Error details of the transfer eligibility validation. </summary>
        [WirePath("details")]
        public string Details { get; }
    }
}
