// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Identifies the status of an invoice section. </summary>
    public readonly partial struct InvoiceSectionState : IEquatable<InvoiceSectionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InvoiceSectionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InvoiceSectionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ActiveValue = "Active";
        private const string DeletedValue = "Deleted";
        private const string DisabledValue = "Disabled";
        private const string UnderReviewValue = "UnderReview";
        private const string WarnedValue = "Warned";
        private const string RestrictedValue = "Restricted";

        /// <summary> Other. </summary>
        public static InvoiceSectionState Other { get; } = new InvoiceSectionState(OtherValue);
        /// <summary> Active. </summary>
        public static InvoiceSectionState Active { get; } = new InvoiceSectionState(ActiveValue);
        /// <summary> Deleted. </summary>
        public static InvoiceSectionState Deleted { get; } = new InvoiceSectionState(DeletedValue);
        /// <summary> Disabled. </summary>
        public static InvoiceSectionState Disabled { get; } = new InvoiceSectionState(DisabledValue);
        /// <summary> UnderReview. </summary>
        public static InvoiceSectionState UnderReview { get; } = new InvoiceSectionState(UnderReviewValue);
        /// <summary> Warned. </summary>
        public static InvoiceSectionState Warned { get; } = new InvoiceSectionState(WarnedValue);
        /// <summary> Restricted. </summary>
        public static InvoiceSectionState Restricted { get; } = new InvoiceSectionState(RestrictedValue);
        /// <summary> Determines if two <see cref="InvoiceSectionState"/> values are the same. </summary>
        public static bool operator ==(InvoiceSectionState left, InvoiceSectionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InvoiceSectionState"/> values are not the same. </summary>
        public static bool operator !=(InvoiceSectionState left, InvoiceSectionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InvoiceSectionState"/>. </summary>
        public static implicit operator InvoiceSectionState(string value) => new InvoiceSectionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InvoiceSectionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InvoiceSectionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
