// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policy that controls invoice section label management at invoice section scope. This is allowed by default. </summary>
    public readonly partial struct InvoiceSectionLabelManagementPolicy : IEquatable<InvoiceSectionLabelManagementPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InvoiceSectionLabelManagementPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InvoiceSectionLabelManagementPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllowedValue = "Allowed";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Other. </summary>
        public static InvoiceSectionLabelManagementPolicy Other { get; } = new InvoiceSectionLabelManagementPolicy(OtherValue);
        /// <summary> Allowed. </summary>
        public static InvoiceSectionLabelManagementPolicy Allowed { get; } = new InvoiceSectionLabelManagementPolicy(AllowedValue);
        /// <summary> NotAllowed. </summary>
        public static InvoiceSectionLabelManagementPolicy NotAllowed { get; } = new InvoiceSectionLabelManagementPolicy(NotAllowedValue);
        /// <summary> Determines if two <see cref="InvoiceSectionLabelManagementPolicy"/> values are the same. </summary>
        public static bool operator ==(InvoiceSectionLabelManagementPolicy left, InvoiceSectionLabelManagementPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InvoiceSectionLabelManagementPolicy"/> values are not the same. </summary>
        public static bool operator !=(InvoiceSectionLabelManagementPolicy left, InvoiceSectionLabelManagementPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InvoiceSectionLabelManagementPolicy"/>. </summary>
        public static implicit operator InvoiceSectionLabelManagementPolicy(string value) => new InvoiceSectionLabelManagementPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InvoiceSectionLabelManagementPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InvoiceSectionLabelManagementPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
