// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The type of the document. </summary>
    public readonly partial struct InvoiceDocumentType : IEquatable<InvoiceDocumentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InvoiceDocumentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InvoiceDocumentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string InvoiceValue = "Invoice";
        private const string VoidNoteValue = "VoidNote";
        private const string TaxReceiptValue = "TaxReceipt";
        private const string CreditNoteValue = "CreditNote";
        private const string SummaryValue = "Summary";
        private const string TransactionsValue = "Transactions";

        /// <summary> Other. </summary>
        public static InvoiceDocumentType Other { get; } = new InvoiceDocumentType(OtherValue);
        /// <summary> Invoice. </summary>
        public static InvoiceDocumentType Invoice { get; } = new InvoiceDocumentType(InvoiceValue);
        /// <summary> VoidNote. </summary>
        public static InvoiceDocumentType VoidNote { get; } = new InvoiceDocumentType(VoidNoteValue);
        /// <summary> TaxReceipt. </summary>
        public static InvoiceDocumentType TaxReceipt { get; } = new InvoiceDocumentType(TaxReceiptValue);
        /// <summary> CreditNote. </summary>
        public static InvoiceDocumentType CreditNote { get; } = new InvoiceDocumentType(CreditNoteValue);
        /// <summary> Summary. </summary>
        public static InvoiceDocumentType Summary { get; } = new InvoiceDocumentType(SummaryValue);
        /// <summary> Transactions. </summary>
        public static InvoiceDocumentType Transactions { get; } = new InvoiceDocumentType(TransactionsValue);
        /// <summary> Determines if two <see cref="InvoiceDocumentType"/> values are the same. </summary>
        public static bool operator ==(InvoiceDocumentType left, InvoiceDocumentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InvoiceDocumentType"/> values are not the same. </summary>
        public static bool operator !=(InvoiceDocumentType left, InvoiceDocumentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InvoiceDocumentType"/>. </summary>
        public static implicit operator InvoiceDocumentType(string value) => new InvoiceDocumentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InvoiceDocumentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InvoiceDocumentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
