// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The properties of a document. </summary>
    public partial class InvoiceDocument
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="InvoiceDocument"/>. </summary>
        internal InvoiceDocument()
        {
            DocumentNumbers = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="InvoiceDocument"/>. </summary>
        /// <param name="documentNumbers"> The document numbers for the invoice document. </param>
        /// <param name="externalUri"> The URL to download the invoice document if the source is external to Microsoft.Billing. </param>
        /// <param name="kind"> The type of the document. </param>
        /// <param name="name"> The ID that uniquely identifies an invoice document. This ID may be an identifier for an invoice PDF, a credit note, or a tax receipt. </param>
        /// <param name="uri"> The URL to download the invoice document if the source is internal to Microsoft.Billing. </param>
        /// <param name="source"> The source of the document. ENF for Brazil and DRS for rest of the world. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal InvoiceDocument(IReadOnlyList<string> documentNumbers, Uri externalUri, InvoiceDocumentType? kind, string name, Uri uri, BillingDocumentSource? source, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DocumentNumbers = documentNumbers;
            ExternalUri = externalUri;
            Kind = kind;
            Name = name;
            Uri = uri;
            Source = source;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The document numbers for the invoice document. </summary>
        [WirePath("documentNumbers")]
        public IReadOnlyList<string> DocumentNumbers { get; }
        /// <summary> The URL to download the invoice document if the source is external to Microsoft.Billing. </summary>
        [WirePath("externalUrl")]
        public Uri ExternalUri { get; }
        /// <summary> The type of the document. </summary>
        [WirePath("kind")]
        public InvoiceDocumentType? Kind { get; }
        /// <summary> The ID that uniquely identifies an invoice document. This ID may be an identifier for an invoice PDF, a credit note, or a tax receipt. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> The URL to download the invoice document if the source is internal to Microsoft.Billing. </summary>
        [WirePath("url")]
        public Uri Uri { get; }
        /// <summary> The source of the document. ENF for Brazil and DRS for rest of the world. </summary>
        [WirePath("source")]
        public BillingDocumentSource? Source { get; }
    }
}
