// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Identifies the billing profile that is linked to another billing profile in indirect purchase motion. </summary>
    public partial class IndirectRelationshipInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IndirectRelationshipInfo"/>. </summary>
        public IndirectRelationshipInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IndirectRelationshipInfo"/>. </summary>
        /// <param name="billingAccountName"> The billing account name of the partner or the customer for an indirect motion. </param>
        /// <param name="billingProfileName"> The billing profile name of the partner or the customer for an indirect motion. </param>
        /// <param name="displayName"> The display name of the partner or customer for an indirect motion. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IndirectRelationshipInfo(string billingAccountName, string billingProfileName, string displayName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BillingAccountName = billingAccountName;
            BillingProfileName = billingProfileName;
            DisplayName = displayName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The billing account name of the partner or the customer for an indirect motion. </summary>
        [WirePath("billingAccountName")]
        public string BillingAccountName { get; set; }
        /// <summary> The billing profile name of the partner or the customer for an indirect motion. </summary>
        [WirePath("billingProfileName")]
        public string BillingProfileName { get; set; }
        /// <summary> The display name of the partner or customer for an indirect motion. </summary>
        [WirePath("displayName")]
        public string DisplayName { get; set; }
    }
}
