// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The billing account extension opted by the company. </summary>
    public readonly partial struct ExtendedTermOption : IEquatable<ExtendedTermOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExtendedTermOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExtendedTermOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string OptedInValue = "Opted-In";
        private const string OptedOutValue = "Opted-Out";

        /// <summary> Other. </summary>
        public static ExtendedTermOption Other { get; } = new ExtendedTermOption(OtherValue);
        /// <summary> Opted-In. </summary>
        public static ExtendedTermOption OptedIn { get; } = new ExtendedTermOption(OptedInValue);
        /// <summary> Opted-Out. </summary>
        public static ExtendedTermOption OptedOut { get; } = new ExtendedTermOption(OptedOutValue);
        /// <summary> Determines if two <see cref="ExtendedTermOption"/> values are the same. </summary>
        public static bool operator ==(ExtendedTermOption left, ExtendedTermOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExtendedTermOption"/> values are not the same. </summary>
        public static bool operator !=(ExtendedTermOption left, ExtendedTermOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExtendedTermOption"/>. </summary>
        public static implicit operator ExtendedTermOption(string value) => new ExtendedTermOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExtendedTermOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExtendedTermOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
