// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policies for Enterprise Agreement enrollments. </summary>
    public partial class EnterpriseAgreementPolicies
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="EnterpriseAgreementPolicies"/>. </summary>
        public EnterpriseAgreementPolicies()
        {
        }

        /// <summary> Initializes a new instance of <see cref="EnterpriseAgreementPolicies"/>. </summary>
        /// <param name="authenticationType"> The state showing the enrollment auth level. </param>
        /// <param name="accountOwnerViewCharges"> The policy that controls whether account owner can view charges. </param>
        /// <param name="departmentAdminViewCharges"> The policy that controls whether department admin can view charges. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal EnterpriseAgreementPolicies(EnrollmentAuthLevelState? authenticationType, EnrollmentAccountOwnerViewCharge? accountOwnerViewCharges, EnrollmentDepartmentAdminViewCharge? departmentAdminViewCharges, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AuthenticationType = authenticationType;
            AccountOwnerViewCharges = accountOwnerViewCharges;
            DepartmentAdminViewCharges = departmentAdminViewCharges;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The state showing the enrollment auth level. </summary>
        [WirePath("authenticationType")]
        public EnrollmentAuthLevelState? AuthenticationType { get; set; }
        /// <summary> The policy that controls whether account owner can view charges. </summary>
        [WirePath("accountOwnerViewCharges")]
        public EnrollmentAccountOwnerViewCharge? AccountOwnerViewCharges { get; set; }
        /// <summary> The policy that controls whether department admin can view charges. </summary>
        [WirePath("departmentAdminViewCharges")]
        public EnrollmentDepartmentAdminViewCharge? DepartmentAdminViewCharges { get; set; }
    }
}
