// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    public partial class EnterpriseAgreementPolicies : IUtf8JsonSerializable, IJsonModel<EnterpriseAgreementPolicies>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<EnterpriseAgreementPolicies>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<EnterpriseAgreementPolicies>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnterpriseAgreementPolicies>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EnterpriseAgreementPolicies)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AuthenticationType))
            {
                writer.WritePropertyName("authenticationType"u8);
                writer.WriteStringValue(AuthenticationType.Value.ToString());
            }
            if (Optional.IsDefined(AccountOwnerViewCharges))
            {
                writer.WritePropertyName("accountOwnerViewCharges"u8);
                writer.WriteStringValue(AccountOwnerViewCharges.Value.ToString());
            }
            if (Optional.IsDefined(DepartmentAdminViewCharges))
            {
                writer.WritePropertyName("departmentAdminViewCharges"u8);
                writer.WriteStringValue(DepartmentAdminViewCharges.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        EnterpriseAgreementPolicies IJsonModel<EnterpriseAgreementPolicies>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnterpriseAgreementPolicies>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(EnterpriseAgreementPolicies)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeEnterpriseAgreementPolicies(document.RootElement, options);
        }

        internal static EnterpriseAgreementPolicies DeserializeEnterpriseAgreementPolicies(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            EnrollmentAuthLevelState? authenticationType = default;
            EnrollmentAccountOwnerViewCharge? accountOwnerViewCharges = default;
            EnrollmentDepartmentAdminViewCharge? departmentAdminViewCharges = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("authenticationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authenticationType = new EnrollmentAuthLevelState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("accountOwnerViewCharges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    accountOwnerViewCharges = new EnrollmentAccountOwnerViewCharge(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("departmentAdminViewCharges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    departmentAdminViewCharges = new EnrollmentDepartmentAdminViewCharge(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new EnterpriseAgreementPolicies(authenticationType, accountOwnerViewCharges, departmentAdminViewCharges, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthenticationType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authenticationType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthenticationType))
                {
                    builder.Append("  authenticationType: ");
                    builder.AppendLine($"'{AuthenticationType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AccountOwnerViewCharges), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  accountOwnerViewCharges: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AccountOwnerViewCharges))
                {
                    builder.Append("  accountOwnerViewCharges: ");
                    builder.AppendLine($"'{AccountOwnerViewCharges.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DepartmentAdminViewCharges), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  departmentAdminViewCharges: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DepartmentAdminViewCharges))
                {
                    builder.Append("  departmentAdminViewCharges: ");
                    builder.AppendLine($"'{DepartmentAdminViewCharges.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<EnterpriseAgreementPolicies>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnterpriseAgreementPolicies>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(EnterpriseAgreementPolicies)} does not support writing '{options.Format}' format.");
            }
        }

        EnterpriseAgreementPolicies IPersistableModel<EnterpriseAgreementPolicies>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<EnterpriseAgreementPolicies>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeEnterpriseAgreementPolicies(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(EnterpriseAgreementPolicies)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<EnterpriseAgreementPolicies>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
