// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Markup status of enrollment, applicable only for indirect enrollments. </summary>
    public readonly partial struct EnrollmentMarkupStatus : IEquatable<EnrollmentMarkupStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnrollmentMarkupStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnrollmentMarkupStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string DisabledValue = "Disabled";
        private const string PreviewValue = "Preview";
        private const string PublishedValue = "Published";
        private const string LockedValue = "Locked";

        /// <summary> Other. </summary>
        public static EnrollmentMarkupStatus Other { get; } = new EnrollmentMarkupStatus(OtherValue);
        /// <summary> Disabled. </summary>
        public static EnrollmentMarkupStatus Disabled { get; } = new EnrollmentMarkupStatus(DisabledValue);
        /// <summary> Preview. </summary>
        public static EnrollmentMarkupStatus Preview { get; } = new EnrollmentMarkupStatus(PreviewValue);
        /// <summary> Published. </summary>
        public static EnrollmentMarkupStatus Published { get; } = new EnrollmentMarkupStatus(PublishedValue);
        /// <summary> Locked. </summary>
        public static EnrollmentMarkupStatus Locked { get; } = new EnrollmentMarkupStatus(LockedValue);
        /// <summary> Determines if two <see cref="EnrollmentMarkupStatus"/> values are the same. </summary>
        public static bool operator ==(EnrollmentMarkupStatus left, EnrollmentMarkupStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnrollmentMarkupStatus"/> values are not the same. </summary>
        public static bool operator !=(EnrollmentMarkupStatus left, EnrollmentMarkupStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnrollmentMarkupStatus"/>. </summary>
        public static implicit operator EnrollmentMarkupStatus(string value) => new EnrollmentMarkupStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnrollmentMarkupStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnrollmentMarkupStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
