// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policy that controls whether department admin can view charges. </summary>
    public readonly partial struct EnrollmentDepartmentAdminViewCharge : IEquatable<EnrollmentDepartmentAdminViewCharge>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnrollmentDepartmentAdminViewCharge"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnrollmentDepartmentAdminViewCharge(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllowedValue = "Allowed";
        private const string DisabledValue = "Disabled";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Other. </summary>
        public static EnrollmentDepartmentAdminViewCharge Other { get; } = new EnrollmentDepartmentAdminViewCharge(OtherValue);
        /// <summary> Allowed. </summary>
        public static EnrollmentDepartmentAdminViewCharge Allowed { get; } = new EnrollmentDepartmentAdminViewCharge(AllowedValue);
        /// <summary> Disabled. </summary>
        public static EnrollmentDepartmentAdminViewCharge Disabled { get; } = new EnrollmentDepartmentAdminViewCharge(DisabledValue);
        /// <summary> NotAllowed. </summary>
        public static EnrollmentDepartmentAdminViewCharge NotAllowed { get; } = new EnrollmentDepartmentAdminViewCharge(NotAllowedValue);
        /// <summary> Determines if two <see cref="EnrollmentDepartmentAdminViewCharge"/> values are the same. </summary>
        public static bool operator ==(EnrollmentDepartmentAdminViewCharge left, EnrollmentDepartmentAdminViewCharge right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnrollmentDepartmentAdminViewCharge"/> values are not the same. </summary>
        public static bool operator !=(EnrollmentDepartmentAdminViewCharge left, EnrollmentDepartmentAdminViewCharge right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnrollmentDepartmentAdminViewCharge"/>. </summary>
        public static implicit operator EnrollmentDepartmentAdminViewCharge(string value) => new EnrollmentDepartmentAdminViewCharge(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnrollmentDepartmentAdminViewCharge other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnrollmentDepartmentAdminViewCharge other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
