// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The state showing the enrollment auth level. </summary>
    public readonly partial struct EnrollmentAuthLevelState : IEquatable<EnrollmentAuthLevelState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnrollmentAuthLevelState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnrollmentAuthLevelState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string MicrosoftAccountOnlyValue = "MicrosoftAccountOnly";
        private const string MixedAccountValue = "MixedAccount";
        private const string OrganizationalAccountCrossTenantValue = "OrganizationalAccountCrossTenant";
        private const string OrganizationalAccountOnlyValue = "OrganizationalAccountOnly";

        /// <summary> Other. </summary>
        public static EnrollmentAuthLevelState Other { get; } = new EnrollmentAuthLevelState(OtherValue);
        /// <summary> MicrosoftAccountOnly. </summary>
        public static EnrollmentAuthLevelState MicrosoftAccountOnly { get; } = new EnrollmentAuthLevelState(MicrosoftAccountOnlyValue);
        /// <summary> MixedAccount. </summary>
        public static EnrollmentAuthLevelState MixedAccount { get; } = new EnrollmentAuthLevelState(MixedAccountValue);
        /// <summary> OrganizationalAccountCrossTenant. </summary>
        public static EnrollmentAuthLevelState OrganizationalAccountCrossTenant { get; } = new EnrollmentAuthLevelState(OrganizationalAccountCrossTenantValue);
        /// <summary> OrganizationalAccountOnly. </summary>
        public static EnrollmentAuthLevelState OrganizationalAccountOnly { get; } = new EnrollmentAuthLevelState(OrganizationalAccountOnlyValue);
        /// <summary> Determines if two <see cref="EnrollmentAuthLevelState"/> values are the same. </summary>
        public static bool operator ==(EnrollmentAuthLevelState left, EnrollmentAuthLevelState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnrollmentAuthLevelState"/> values are not the same. </summary>
        public static bool operator !=(EnrollmentAuthLevelState left, EnrollmentAuthLevelState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnrollmentAuthLevelState"/>. </summary>
        public static implicit operator EnrollmentAuthLevelState(string value) => new EnrollmentAuthLevelState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnrollmentAuthLevelState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnrollmentAuthLevelState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
