// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policy that controls whether account owner can view charges. </summary>
    public readonly partial struct EnrollmentAccountOwnerViewCharge : IEquatable<EnrollmentAccountOwnerViewCharge>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EnrollmentAccountOwnerViewCharge"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EnrollmentAccountOwnerViewCharge(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllowedValue = "Allowed";
        private const string DisabledValue = "Disabled";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Other. </summary>
        public static EnrollmentAccountOwnerViewCharge Other { get; } = new EnrollmentAccountOwnerViewCharge(OtherValue);
        /// <summary> Allowed. </summary>
        public static EnrollmentAccountOwnerViewCharge Allowed { get; } = new EnrollmentAccountOwnerViewCharge(AllowedValue);
        /// <summary> Disabled. </summary>
        public static EnrollmentAccountOwnerViewCharge Disabled { get; } = new EnrollmentAccountOwnerViewCharge(DisabledValue);
        /// <summary> NotAllowed. </summary>
        public static EnrollmentAccountOwnerViewCharge NotAllowed { get; } = new EnrollmentAccountOwnerViewCharge(NotAllowedValue);
        /// <summary> Determines if two <see cref="EnrollmentAccountOwnerViewCharge"/> values are the same. </summary>
        public static bool operator ==(EnrollmentAccountOwnerViewCharge left, EnrollmentAccountOwnerViewCharge right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EnrollmentAccountOwnerViewCharge"/> values are not the same. </summary>
        public static bool operator !=(EnrollmentAccountOwnerViewCharge left, EnrollmentAccountOwnerViewCharge right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EnrollmentAccountOwnerViewCharge"/>. </summary>
        public static implicit operator EnrollmentAccountOwnerViewCharge(string value) => new EnrollmentAccountOwnerViewCharge(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EnrollmentAccountOwnerViewCharge other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EnrollmentAccountOwnerViewCharge other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
