// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Type of the products that can be transferred. </summary>
    public readonly partial struct EligibleProductType : IEquatable<EligibleProductType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EligibleProductType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EligibleProductType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DevTestAzureSubscriptionValue = "DevTestAzureSubscription";
        private const string StandardAzureSubscriptionValue = "StandardAzureSubscription";
        private const string AzureReservationValue = "AzureReservation";

        /// <summary> DevTestAzureSubscription. </summary>
        public static EligibleProductType DevTestAzureSubscription { get; } = new EligibleProductType(DevTestAzureSubscriptionValue);
        /// <summary> StandardAzureSubscription. </summary>
        public static EligibleProductType StandardAzureSubscription { get; } = new EligibleProductType(StandardAzureSubscriptionValue);
        /// <summary> AzureReservation. </summary>
        public static EligibleProductType AzureReservation { get; } = new EligibleProductType(AzureReservationValue);
        /// <summary> Determines if two <see cref="EligibleProductType"/> values are the same. </summary>
        public static bool operator ==(EligibleProductType left, EligibleProductType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EligibleProductType"/> values are not the same. </summary>
        public static bool operator !=(EligibleProductType left, EligibleProductType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EligibleProductType"/>. </summary>
        public static implicit operator EligibleProductType(string value) => new EligibleProductType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EligibleProductType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EligibleProductType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
