// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Status describing if invoice section is eligible to be deleted. </summary>
    public readonly partial struct DeleteInvoiceSectionEligibilityStatus : IEquatable<DeleteInvoiceSectionEligibilityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeleteInvoiceSectionEligibilityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeleteInvoiceSectionEligibilityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowedValue = "Allowed";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Allowed. </summary>
        public static DeleteInvoiceSectionEligibilityStatus Allowed { get; } = new DeleteInvoiceSectionEligibilityStatus(AllowedValue);
        /// <summary> NotAllowed. </summary>
        public static DeleteInvoiceSectionEligibilityStatus NotAllowed { get; } = new DeleteInvoiceSectionEligibilityStatus(NotAllowedValue);
        /// <summary> Determines if two <see cref="DeleteInvoiceSectionEligibilityStatus"/> values are the same. </summary>
        public static bool operator ==(DeleteInvoiceSectionEligibilityStatus left, DeleteInvoiceSectionEligibilityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeleteInvoiceSectionEligibilityStatus"/> values are not the same. </summary>
        public static bool operator !=(DeleteInvoiceSectionEligibilityStatus left, DeleteInvoiceSectionEligibilityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeleteInvoiceSectionEligibilityStatus"/>. </summary>
        public static implicit operator DeleteInvoiceSectionEligibilityStatus(string value) => new DeleteInvoiceSectionEligibilityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeleteInvoiceSectionEligibilityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeleteInvoiceSectionEligibilityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
