// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Code for the delete invoice section validation. </summary>
    public readonly partial struct DeleteInvoiceSectionEligibilityCode : IEquatable<DeleteInvoiceSectionEligibilityCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeleteInvoiceSectionEligibilityCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeleteInvoiceSectionEligibilityCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string LastInvoiceSectionValue = "LastInvoiceSection";
        private const string ActiveAzurePlansValue = "ActiveAzurePlans";
        private const string ReservedInstancesValue = "ReservedInstances";
        private const string ActiveBillingSubscriptionsValue = "ActiveBillingSubscriptions";

        /// <summary> Other. </summary>
        public static DeleteInvoiceSectionEligibilityCode Other { get; } = new DeleteInvoiceSectionEligibilityCode(OtherValue);
        /// <summary> LastInvoiceSection. </summary>
        public static DeleteInvoiceSectionEligibilityCode LastInvoiceSection { get; } = new DeleteInvoiceSectionEligibilityCode(LastInvoiceSectionValue);
        /// <summary> ActiveAzurePlans. </summary>
        public static DeleteInvoiceSectionEligibilityCode ActiveAzurePlans { get; } = new DeleteInvoiceSectionEligibilityCode(ActiveAzurePlansValue);
        /// <summary> ReservedInstances. </summary>
        public static DeleteInvoiceSectionEligibilityCode ReservedInstances { get; } = new DeleteInvoiceSectionEligibilityCode(ReservedInstancesValue);
        /// <summary> ActiveBillingSubscriptions. </summary>
        public static DeleteInvoiceSectionEligibilityCode ActiveBillingSubscriptions { get; } = new DeleteInvoiceSectionEligibilityCode(ActiveBillingSubscriptionsValue);
        /// <summary> Determines if two <see cref="DeleteInvoiceSectionEligibilityCode"/> values are the same. </summary>
        public static bool operator ==(DeleteInvoiceSectionEligibilityCode left, DeleteInvoiceSectionEligibilityCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeleteInvoiceSectionEligibilityCode"/> values are not the same. </summary>
        public static bool operator !=(DeleteInvoiceSectionEligibilityCode left, DeleteInvoiceSectionEligibilityCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeleteInvoiceSectionEligibilityCode"/>. </summary>
        public static implicit operator DeleteInvoiceSectionEligibilityCode(string value) => new DeleteInvoiceSectionEligibilityCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeleteInvoiceSectionEligibilityCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeleteInvoiceSectionEligibilityCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
