// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Status describing if billing profile is eligible to be deleted. </summary>
    public readonly partial struct DeleteBillingProfileEligibilityStatus : IEquatable<DeleteBillingProfileEligibilityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DeleteBillingProfileEligibilityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DeleteBillingProfileEligibilityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllowedValue = "Allowed";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Allowed. </summary>
        public static DeleteBillingProfileEligibilityStatus Allowed { get; } = new DeleteBillingProfileEligibilityStatus(AllowedValue);
        /// <summary> NotAllowed. </summary>
        public static DeleteBillingProfileEligibilityStatus NotAllowed { get; } = new DeleteBillingProfileEligibilityStatus(NotAllowedValue);
        /// <summary> Determines if two <see cref="DeleteBillingProfileEligibilityStatus"/> values are the same. </summary>
        public static bool operator ==(DeleteBillingProfileEligibilityStatus left, DeleteBillingProfileEligibilityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DeleteBillingProfileEligibilityStatus"/> values are not the same. </summary>
        public static bool operator !=(DeleteBillingProfileEligibilityStatus left, DeleteBillingProfileEligibilityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DeleteBillingProfileEligibilityStatus"/>. </summary>
        public static implicit operator DeleteBillingProfileEligibilityStatus(string value) => new DeleteBillingProfileEligibilityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DeleteBillingProfileEligibilityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DeleteBillingProfileEligibilityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
