// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Cancellation reason. </summary>
    public readonly partial struct CustomerSubscriptionCancellationReason : IEquatable<CustomerSubscriptionCancellationReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomerSubscriptionCancellationReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomerSubscriptionCancellationReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string CompromiseValue = "Compromise";
        private const string DisputeValue = "Dispute";

        /// <summary> Other. </summary>
        public static CustomerSubscriptionCancellationReason Other { get; } = new CustomerSubscriptionCancellationReason(OtherValue);
        /// <summary> Compromise. </summary>
        public static CustomerSubscriptionCancellationReason Compromise { get; } = new CustomerSubscriptionCancellationReason(CompromiseValue);
        /// <summary> Dispute. </summary>
        public static CustomerSubscriptionCancellationReason Dispute { get; } = new CustomerSubscriptionCancellationReason(DisputeValue);
        /// <summary> Determines if two <see cref="CustomerSubscriptionCancellationReason"/> values are the same. </summary>
        public static bool operator ==(CustomerSubscriptionCancellationReason left, CustomerSubscriptionCancellationReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomerSubscriptionCancellationReason"/> values are not the same. </summary>
        public static bool operator !=(CustomerSubscriptionCancellationReason left, CustomerSubscriptionCancellationReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomerSubscriptionCancellationReason"/>. </summary>
        public static implicit operator CustomerSubscriptionCancellationReason(string value) => new CustomerSubscriptionCancellationReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomerSubscriptionCancellationReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomerSubscriptionCancellationReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
