// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Request parameters for cancel customer subscription. </summary>
    public partial class CancelSubscriptionContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CancelSubscriptionContent"/>. </summary>
        /// <param name="cancellationReason"> Cancellation reason. </param>
        public CancelSubscriptionContent(CustomerSubscriptionCancellationReason cancellationReason)
        {
            CancellationReason = cancellationReason;
        }

        /// <summary> Initializes a new instance of <see cref="CancelSubscriptionContent"/>. </summary>
        /// <param name="cancellationReason"> Cancellation reason. </param>
        /// <param name="customerId"> The fully qualified ID that uniquely identifies a customer. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CancelSubscriptionContent(CustomerSubscriptionCancellationReason cancellationReason, ResourceIdentifier customerId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CancellationReason = cancellationReason;
            CustomerId = customerId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CancelSubscriptionContent"/> for deserialization. </summary>
        internal CancelSubscriptionContent()
        {
        }

        /// <summary> Cancellation reason. </summary>
        [WirePath("cancellationReason")]
        public CustomerSubscriptionCancellationReason CancellationReason { get; }
        /// <summary> The fully qualified ID that uniquely identifies a customer. </summary>
        [WirePath("customerId")]
        public ResourceIdentifier CustomerId { get; set; }
    }
}
