// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The details for a billing account transitioned from agreement type Microsoft Online Services Program to agreement type Microsoft Customer Agreement. </summary>
    public partial class BillingTransitionDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingTransitionDetails"/>. </summary>
        internal BillingTransitionDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingTransitionDetails"/>. </summary>
        /// <param name="transitionOn"> The transition completion date. </param>
        /// <param name="anniversaryDay"> The anniversary day of the pre-transitioned account of type Microsoft Online Services Program. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingTransitionDetails(DateTimeOffset? transitionOn, int? anniversaryDay, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TransitionOn = transitionOn;
            AnniversaryDay = anniversaryDay;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The transition completion date. </summary>
        [WirePath("transitionDate")]
        public DateTimeOffset? TransitionOn { get; }
        /// <summary> The anniversary day of the pre-transitioned account of type Microsoft Online Services Program. </summary>
        [WirePath("anniversaryDay")]
        public int? AnniversaryDay { get; }
    }
}
