// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> A transaction. </summary>
    public partial class BillingTransactionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingTransactionProperties"/>. </summary>
        public BillingTransactionProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingTransactionProperties"/>. </summary>
        /// <param name="azureCreditApplied"> The amount of any Azure credits automatically applied to this transaction. </param>
        /// <param name="azurePlan"> Details of the Azure plan. </param>
        /// <param name="billingCurrency"> The ISO 4217 code for the currency in which this transaction is billed. </param>
        /// <param name="billingProfileDisplayName"> The name of the billing profile. </param>
        /// <param name="billingProfileId"> The fully qualified ID that uniquely identifies a billing profile. </param>
        /// <param name="consumptionCommitmentDecremented"> The amount of Microsoft Azure Consumption Commitment(MACC) decrement through the transaction. </param>
        /// <param name="customerDisplayName"> The name of the customer. </param>
        /// <param name="customerId"> The fully qualified ID that uniquely identifies a customer. </param>
        /// <param name="creditType"> The credit type of the transaction. Applies only to credited transactions. </param>
        /// <param name="on"> The date of transaction. </param>
        /// <param name="discount"> The percentage discount, if any, applied to this transaction. </param>
        /// <param name="effectivePrice"> The price of the product after applying any discounts. </param>
        /// <param name="exchangeRate"> The exchange rate used to convert charged amount to billing currency, if applicable. </param>
        /// <param name="invoice"> Invoice name on which the transaction was billed or 'Pending' if the transaction is not billed. </param>
        /// <param name="invoiceId"> The fully qualified ID of the invoice on which the transaction was billed. This field is only applicable for transactions which are billed. </param>
        /// <param name="invoiceSectionDisplayName"> The name of the invoice section. </param>
        /// <param name="invoiceSectionId"> The fully qualified ID that uniquely identifies an invoice section. </param>
        /// <param name="isThirdParty"> Whether or not the transaction is third party. </param>
        /// <param name="kind"> Type of the transaction, billed or unbilled. </param>
        /// <param name="marketPrice"> The retail price of the product. </param>
        /// <param name="partNumber"> The part number of the product for which the transaction took place. The field is only applicable for Enterprise Agreement invoices. </param>
        /// <param name="pricingCurrency"> The ISO 4217 code for the currency in which the product is priced. </param>
        /// <param name="productDescription"> The description of the product for which the transaction took place. </param>
        /// <param name="productFamily"> The family of the product for which the transaction took place. </param>
        /// <param name="productTypeId"> The ID of the product type for which the transaction took place. </param>
        /// <param name="productType"> The type of the product for which the transaction took place. </param>
        /// <param name="quantity"> The quantity purchased in the transaction. </param>
        /// <param name="reasonCode"> There reason code for the transaction. </param>
        /// <param name="servicePeriodStartOn"> The date of the purchase of the product, or the start date of the month in which usage started. </param>
        /// <param name="servicePeriodEndOn"> The end date of the product term, or the end date of the month in which usage ended. </param>
        /// <param name="subTotal"> The pre-tax charged amount for the transaction. </param>
        /// <param name="tax"> The tax amount applied to the transaction. </param>
        /// <param name="transactionAmount"> The charge associated with the transaction. </param>
        /// <param name="transactionType"> The type of transaction. </param>
        /// <param name="units"> The number of units used for a given product. </param>
        /// <param name="unitOfMeasure"> The unit of measure used to bill for the product. For example, compute services are billed per hour. </param>
        /// <param name="unitType"> The description for the unit of measure for a given product. </param>
        /// <param name="specialTaxationType"> Identifies the type of tax calculation used for the invoice. The field is applicable only to invoices with special tax calculation logic. </param>
        /// <param name="refundTransactionDetails"> The refund details of a transaction. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingTransactionProperties(BillingAmount azureCreditApplied, string azurePlan, string billingCurrency, BinaryData billingProfileDisplayName, ResourceIdentifier billingProfileId, BillingAmount consumptionCommitmentDecremented, string customerDisplayName, ResourceIdentifier customerId, BillingTransactionCreditType? creditType, DateTimeOffset? @on, float? discount, BillingAmount effectivePrice, float? exchangeRate, string invoice, ResourceIdentifier invoiceId, string invoiceSectionDisplayName, ResourceIdentifier invoiceSectionId, bool? isThirdParty, BillingTransactionKind? kind, BillingAmount marketPrice, string partNumber, string pricingCurrency, string productDescription, string productFamily, string productTypeId, string productType, int? quantity, string reasonCode, DateTimeOffset? servicePeriodStartOn, DateTimeOffset? servicePeriodEndOn, BillingAmount subTotal, BillingAmount tax, BillingAmount transactionAmount, string transactionType, float? units, string unitOfMeasure, string unitType, SpecialTaxationType? specialTaxationType, RefundTransactionDetails refundTransactionDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AzureCreditApplied = azureCreditApplied;
            AzurePlan = azurePlan;
            BillingCurrency = billingCurrency;
            BillingProfileDisplayName = billingProfileDisplayName;
            BillingProfileId = billingProfileId;
            ConsumptionCommitmentDecremented = consumptionCommitmentDecremented;
            CustomerDisplayName = customerDisplayName;
            CustomerId = customerId;
            CreditType = creditType;
            On = @on;
            Discount = discount;
            EffectivePrice = effectivePrice;
            ExchangeRate = exchangeRate;
            Invoice = invoice;
            InvoiceId = invoiceId;
            InvoiceSectionDisplayName = invoiceSectionDisplayName;
            InvoiceSectionId = invoiceSectionId;
            IsThirdParty = isThirdParty;
            Kind = kind;
            MarketPrice = marketPrice;
            PartNumber = partNumber;
            PricingCurrency = pricingCurrency;
            ProductDescription = productDescription;
            ProductFamily = productFamily;
            ProductTypeId = productTypeId;
            ProductType = productType;
            Quantity = quantity;
            ReasonCode = reasonCode;
            ServicePeriodStartOn = servicePeriodStartOn;
            ServicePeriodEndOn = servicePeriodEndOn;
            SubTotal = subTotal;
            Tax = tax;
            TransactionAmount = transactionAmount;
            TransactionType = transactionType;
            Units = units;
            UnitOfMeasure = unitOfMeasure;
            UnitType = unitType;
            SpecialTaxationType = specialTaxationType;
            RefundTransactionDetails = refundTransactionDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The amount of any Azure credits automatically applied to this transaction. </summary>
        [WirePath("azureCreditApplied")]
        public BillingAmount AzureCreditApplied { get; }
        /// <summary> Details of the Azure plan. </summary>
        [WirePath("azurePlan")]
        public string AzurePlan { get; set; }
        /// <summary> The ISO 4217 code for the currency in which this transaction is billed. </summary>
        [WirePath("billingCurrency")]
        public string BillingCurrency { get; set; }
        /// <summary>
        /// The name of the billing profile.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("billingProfileDisplayName")]
        public BinaryData BillingProfileDisplayName { get; set; }
        /// <summary> The fully qualified ID that uniquely identifies a billing profile. </summary>
        [WirePath("billingProfileId")]
        public ResourceIdentifier BillingProfileId { get; set; }
        /// <summary> The amount of Microsoft Azure Consumption Commitment(MACC) decrement through the transaction. </summary>
        [WirePath("consumptionCommitmentDecremented")]
        public BillingAmount ConsumptionCommitmentDecremented { get; }
        /// <summary> The name of the customer. </summary>
        [WirePath("customerDisplayName")]
        public string CustomerDisplayName { get; set; }
        /// <summary> The fully qualified ID that uniquely identifies a customer. </summary>
        [WirePath("customerId")]
        public ResourceIdentifier CustomerId { get; set; }
        /// <summary> The credit type of the transaction. Applies only to credited transactions. </summary>
        [WirePath("creditType")]
        public BillingTransactionCreditType? CreditType { get; set; }
        /// <summary> The date of transaction. </summary>
        [WirePath("date")]
        public DateTimeOffset? On { get; set; }
        /// <summary> The percentage discount, if any, applied to this transaction. </summary>
        [WirePath("discount")]
        public float? Discount { get; set; }
        /// <summary> The price of the product after applying any discounts. </summary>
        [WirePath("effectivePrice")]
        public BillingAmount EffectivePrice { get; }
        /// <summary> The exchange rate used to convert charged amount to billing currency, if applicable. </summary>
        [WirePath("exchangeRate")]
        public float? ExchangeRate { get; set; }
        /// <summary> Invoice name on which the transaction was billed or 'Pending' if the transaction is not billed. </summary>
        [WirePath("invoice")]
        public string Invoice { get; set; }
        /// <summary> The fully qualified ID of the invoice on which the transaction was billed. This field is only applicable for transactions which are billed. </summary>
        [WirePath("invoiceId")]
        public ResourceIdentifier InvoiceId { get; set; }
        /// <summary> The name of the invoice section. </summary>
        [WirePath("invoiceSectionDisplayName")]
        public string InvoiceSectionDisplayName { get; set; }
        /// <summary> The fully qualified ID that uniquely identifies an invoice section. </summary>
        [WirePath("invoiceSectionId")]
        public ResourceIdentifier InvoiceSectionId { get; set; }
        /// <summary> Whether or not the transaction is third party. </summary>
        [WirePath("isThirdParty")]
        public bool? IsThirdParty { get; set; }
        /// <summary> Type of the transaction, billed or unbilled. </summary>
        [WirePath("kind")]
        public BillingTransactionKind? Kind { get; set; }
        /// <summary> The retail price of the product. </summary>
        [WirePath("marketPrice")]
        public BillingAmount MarketPrice { get; }
        /// <summary> The part number of the product for which the transaction took place. The field is only applicable for Enterprise Agreement invoices. </summary>
        [WirePath("partNumber")]
        public string PartNumber { get; set; }
        /// <summary> The ISO 4217 code for the currency in which the product is priced. </summary>
        [WirePath("pricingCurrency")]
        public string PricingCurrency { get; set; }
        /// <summary> The description of the product for which the transaction took place. </summary>
        [WirePath("productDescription")]
        public string ProductDescription { get; set; }
        /// <summary> The family of the product for which the transaction took place. </summary>
        [WirePath("productFamily")]
        public string ProductFamily { get; set; }
        /// <summary> The ID of the product type for which the transaction took place. </summary>
        [WirePath("productTypeId")]
        public string ProductTypeId { get; set; }
        /// <summary> The type of the product for which the transaction took place. </summary>
        [WirePath("productType")]
        public string ProductType { get; set; }
        /// <summary> The quantity purchased in the transaction. </summary>
        [WirePath("quantity")]
        public int? Quantity { get; set; }
        /// <summary> There reason code for the transaction. </summary>
        [WirePath("reasonCode")]
        public string ReasonCode { get; set; }
        /// <summary> The date of the purchase of the product, or the start date of the month in which usage started. </summary>
        [WirePath("servicePeriodStartDate")]
        public DateTimeOffset? ServicePeriodStartOn { get; set; }
        /// <summary> The end date of the product term, or the end date of the month in which usage ended. </summary>
        [WirePath("servicePeriodEndDate")]
        public DateTimeOffset? ServicePeriodEndOn { get; set; }
        /// <summary> The pre-tax charged amount for the transaction. </summary>
        [WirePath("subTotal")]
        public BillingAmount SubTotal { get; }
        /// <summary> The tax amount applied to the transaction. </summary>
        [WirePath("tax")]
        public BillingAmount Tax { get; }
        /// <summary> The charge associated with the transaction. </summary>
        [WirePath("transactionAmount")]
        public BillingAmount TransactionAmount { get; }
        /// <summary> The type of transaction. </summary>
        [WirePath("transactionType")]
        public string TransactionType { get; set; }
        /// <summary> The number of units used for a given product. </summary>
        [WirePath("units")]
        public float? Units { get; set; }
        /// <summary> The unit of measure used to bill for the product. For example, compute services are billed per hour. </summary>
        [WirePath("unitOfMeasure")]
        public string UnitOfMeasure { get; set; }
        /// <summary> The description for the unit of measure for a given product. </summary>
        [WirePath("unitType")]
        public string UnitType { get; set; }
        /// <summary> Identifies the type of tax calculation used for the invoice. The field is applicable only to invoices with special tax calculation logic. </summary>
        [WirePath("specialTaxationType")]
        public SpecialTaxationType? SpecialTaxationType { get; set; }
        /// <summary> The refund details of a transaction. </summary>
        [WirePath("refundTransactionDetails")]
        public RefundTransactionDetails RefundTransactionDetails { get; set; }
    }
}
