// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Type of the transaction, billed or unbilled. </summary>
    public readonly partial struct BillingTransactionKind : IEquatable<BillingTransactionKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingTransactionKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingTransactionKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllValue = "All";
        private const string ReservationValue = "Reservation";

        /// <summary> Other. </summary>
        public static BillingTransactionKind Other { get; } = new BillingTransactionKind(OtherValue);
        /// <summary> All. </summary>
        public static BillingTransactionKind All { get; } = new BillingTransactionKind(AllValue);
        /// <summary> Reservation. </summary>
        public static BillingTransactionKind Reservation { get; } = new BillingTransactionKind(ReservationValue);
        /// <summary> Determines if two <see cref="BillingTransactionKind"/> values are the same. </summary>
        public static bool operator ==(BillingTransactionKind left, BillingTransactionKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingTransactionKind"/> values are not the same. </summary>
        public static bool operator !=(BillingTransactionKind left, BillingTransactionKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingTransactionKind"/>. </summary>
        public static implicit operator BillingTransactionKind(string value) => new BillingTransactionKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingTransactionKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingTransactionKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
