// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The credit type of the transaction. Applies only to credited transactions. </summary>
    public readonly partial struct BillingTransactionCreditType : IEquatable<BillingTransactionCreditType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingTransactionCreditType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingTransactionCreditType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AzureFreeCreditValue = "AzureFreeCredit";
        private const string AzureCreditOfferValue = "AzureCreditOffer";
        private const string ServiceInterruptionValue = "ServiceInterruption";
        private const string RefundValue = "Refund";

        /// <summary> Other. </summary>
        public static BillingTransactionCreditType Other { get; } = new BillingTransactionCreditType(OtherValue);
        /// <summary> AzureFreeCredit. </summary>
        public static BillingTransactionCreditType AzureFreeCredit { get; } = new BillingTransactionCreditType(AzureFreeCreditValue);
        /// <summary> AzureCreditOffer. </summary>
        public static BillingTransactionCreditType AzureCreditOffer { get; } = new BillingTransactionCreditType(AzureCreditOfferValue);
        /// <summary> ServiceInterruption. </summary>
        public static BillingTransactionCreditType ServiceInterruption { get; } = new BillingTransactionCreditType(ServiceInterruptionValue);
        /// <summary> Refund. </summary>
        public static BillingTransactionCreditType Refund { get; } = new BillingTransactionCreditType(RefundValue);
        /// <summary> Determines if two <see cref="BillingTransactionCreditType"/> values are the same. </summary>
        public static bool operator ==(BillingTransactionCreditType left, BillingTransactionCreditType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingTransactionCreditType"/> values are not the same. </summary>
        public static bool operator !=(BillingTransactionCreditType left, BillingTransactionCreditType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingTransactionCreditType"/>. </summary>
        public static implicit operator BillingTransactionCreditType(string value) => new BillingTransactionCreditType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingTransactionCreditType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingTransactionCreditType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
