// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The status of the tax identifier. </summary>
    public readonly partial struct BillingTaxIdentifierStatus : IEquatable<BillingTaxIdentifierStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingTaxIdentifierStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingTaxIdentifierStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string ValidValue = "Valid";
        private const string InvalidValue = "Invalid";

        /// <summary> Other. </summary>
        public static BillingTaxIdentifierStatus Other { get; } = new BillingTaxIdentifierStatus(OtherValue);
        /// <summary> Valid. </summary>
        public static BillingTaxIdentifierStatus Valid { get; } = new BillingTaxIdentifierStatus(ValidValue);
        /// <summary> Invalid. </summary>
        public static BillingTaxIdentifierStatus Invalid { get; } = new BillingTaxIdentifierStatus(InvalidValue);
        /// <summary> Determines if two <see cref="BillingTaxIdentifierStatus"/> values are the same. </summary>
        public static bool operator ==(BillingTaxIdentifierStatus left, BillingTaxIdentifierStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingTaxIdentifierStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingTaxIdentifierStatus left, BillingTaxIdentifierStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingTaxIdentifierStatus"/>. </summary>
        public static implicit operator BillingTaxIdentifierStatus(string value) => new BillingTaxIdentifierStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingTaxIdentifierStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingTaxIdentifierStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
