// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> System imposed policies that regulate behavior of the subscription. </summary>
    public partial class BillingSystemOverrides
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingSystemOverrides"/>. </summary>
        public BillingSystemOverrides()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingSystemOverrides"/>. </summary>
        /// <param name="cancellation"> The policy override for the subscription indicates whether the self-serve cancellation or seat reduction is allowed. </param>
        /// <param name="cancellationAllowedEndOn"> The end date in UTC time by when the self-serve cancellation ends. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingSystemOverrides(PolicyOverrideCancellation? cancellation, DateTimeOffset? cancellationAllowedEndOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Cancellation = cancellation;
            CancellationAllowedEndOn = cancellationAllowedEndOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The policy override for the subscription indicates whether the self-serve cancellation or seat reduction is allowed. </summary>
        [WirePath("cancellation")]
        public PolicyOverrideCancellation? Cancellation { get; }
        /// <summary> The end date in UTC time by when the self-serve cancellation ends. </summary>
        [WirePath("cancellationAllowedEndDate")]
        public DateTimeOffset? CancellationAllowedEndOn { get; }
    }
}
