// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The supported account types. </summary>
    public readonly partial struct BillingSupportedAccountType : IEquatable<BillingSupportedAccountType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingSupportedAccountType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingSupportedAccountType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string PartnerValue = "Partner";
        private const string IndividualValue = "Individual";
        private const string EnterpriseValue = "Enterprise";

        /// <summary> None. </summary>
        public static BillingSupportedAccountType None { get; } = new BillingSupportedAccountType(NoneValue);
        /// <summary> Partner. </summary>
        public static BillingSupportedAccountType Partner { get; } = new BillingSupportedAccountType(PartnerValue);
        /// <summary> Individual. </summary>
        public static BillingSupportedAccountType Individual { get; } = new BillingSupportedAccountType(IndividualValue);
        /// <summary> Enterprise. </summary>
        public static BillingSupportedAccountType Enterprise { get; } = new BillingSupportedAccountType(EnterpriseValue);
        /// <summary> Determines if two <see cref="BillingSupportedAccountType"/> values are the same. </summary>
        public static bool operator ==(BillingSupportedAccountType left, BillingSupportedAccountType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingSupportedAccountType"/> values are not the same. </summary>
        public static bool operator !=(BillingSupportedAccountType left, BillingSupportedAccountType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingSupportedAccountType"/>. </summary>
        public static implicit operator BillingSupportedAccountType(string value) => new BillingSupportedAccountType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingSupportedAccountType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingSupportedAccountType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
